# -*- coding: utf-8 -*-
"""
Created on Tue Oct 26 21:43:11 2021

@author: alice
"""

import matplotlib.pyplot as plt
from ModuleJoueur import Joueur


class Graphique :
    def __init__(self, joueur : Joueur):
        self.__habilite = []
        self.__endurance = []
        self.__chance = []
        self.__or = []
        self.__provisions = []
        self.__potion = []
        self.__joueur = joueur
        
        
    def actualiser(self):
        self.__habilite.append(self.__joueur.get_hab())
        self.__endurance.append(self.__joueur.get_end())
        self.__chance.append(self.__joueur.get_cha())
        self.__or.append(self.__joueur.get_or())
        self.__provisions.append(self.__joueur.get_prov())
        self.__potion.append(self.__joueur.get_potion()*13.5)

    
    def afficher(self):
        x=range(0,len(self.__habilite))
        fig, axe1 = plt.subplots()
        axe1.plot(x,self.__habilite,'b',label='habilité')
        axe1.plot(x,self.__endurance,'r',label='endurance')
        axe1.plot(x,self.__chance,'g',label='chance')
        axe1.set_xlabel("pièces visitables")
        axe1.set_ylabel("habilité, endurance, chance")
    
        axe2=axe1.twinx()
        axe2.plot(x,self.__or,"y--",label="or")
        axe2.plot(x,self.__provisions,"m--",label="provisions")
        axe2.plot(x,self.__potion,"k.",label="potion")
        axe2.set_ylabel("or, provisions, potion")
        
        axe1.legend(loc="center left")
        axe2.legend(loc="right")
        axe1.grid()
        
        return fig
        